<?php
error_reporting(E_ALL);  // Iespējo kļūdu ziņošanu, lai varētu labot problēmas
ini_set('display_errors', 1);  // Rāda kļūdas tieši pārlūkā

include('db_connection.php');  // Iekļauj datubāzes savienojuma failu

header('Content-Type: application/json');  // Iestata atbildes formātu kā JSON

// Dekodē JSON datus no pieprasījuma ķermeņa
$data = json_decode(file_get_contents("php://input"), true);

// Pārbauda, vai ir nodrošināti nepieciešamie dati: lietotāja ID, vārds un e-pasts
if (isset($data['id']) && isset($data['username']) && isset($data['email'])) {
    // Piešķir mainīgajiem saņemto vērtību
    $userId = $data['id'];
    $username = $data['username'];
    $email = $data['email'];

    // Izvairās no SQL injekcijām, attīrot lietotāja ievadītos datus
    $username = mysqli_real_escape_string($conn, $username);
    $email = mysqli_real_escape_string($conn, $email);

    // Ja ir sniegti dati par paroles maiņu
    if (isset($data['currentPassword']) && isset($data['newPassword'])) {
        $currentPassword = mysqli_real_escape_string($conn, $data['currentPassword']);
        $newPassword = mysqli_real_escape_string($conn, $data['newPassword']);

        // Verificē, vai norādītā pašreizējā parole atbilst datubāzē esošajai
        $result = mysqli_query($conn, "SELECT password FROM users WHERE id = $userId");
        $user = mysqli_fetch_assoc($result);

        // Ja parole ir pareiza, tad atjaunina arī jauno paroli
        if ($user && password_verify($currentPassword, $user['password'])) {
            // Parole tiek šifrēta, lai nodrošinātu drošību
            $hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT);

            // Izveido SQL vaicājumu, lai atjauninātu lietotāja datus, iekļaujot arī paroli
            $query = "UPDATE users SET username = '$username', email = '$email', password = '$hashedPassword' WHERE id = $userId";
        } else {
            // Ja pašreizējā parole nav pareiza, atgriež kļūdas ziņojumu
            echo json_encode(['error' => 'Pašreizējā parole ir nepareiza.']);
            exit();
        }
    } else {
        // Ja nav paroles maiņas, tiek atjaunināti tikai lietotāja vārds un e-pasts
        $query = "UPDATE users SET username = '$username', email = '$email' WHERE id = $userId";
    }

    // Izpilda SQL vaicājumu, lai atjauninātu datus
    if (mysqli_query($conn, $query)) {
        // Ja viss ir veiksmīgi, atgriež veiksmīgas atjaunināšanas ziņojumu
        echo json_encode(['success' => true]);
    } else {
        // Ja rodas problēma ar atjaunināšanu, atgriež kļūdas ziņojumu
        echo json_encode(['error' => 'Neizdevās atjaunināt profilu.']);
    }
} else {
    // Ja trūkst nepieciešamo datu, atgriež kļūdas ziņojumu
    echo json_encode(['error' => 'Trūkst nepieciešamie lauki.']);
}

// Aizver datubāzes savienojumu
mysqli_close($conn);
?>
